/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.event.client.OverlayRenderCallback;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1324;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_757;
import slimeknights.mantle.config.Config;

public class ExtraHeartRenderHandler {
    private static final class_2960 ICON_HEARTS = new class_2960("mantle", "textures/gui/hearts.png");
    private static final class_2960 ICON_ABSORB = new class_2960("mantle", "textures/gui/absorb.png");
    private static final class_2960 ICON_VANILLA = class_329.field_44654;
    private final class_310 mc = class_310.method_1551();
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private long healthUpdateCounter = 0L;
    private long lastSystemTime = 0L;
    private final Random rand = new Random();
    private int regen;

    private void blit(class_332 guiGraphics, class_2960 texture, int x, int y, int textureX, int textureY, int width, int height) {
        guiGraphics.method_25302(texture, x, y, textureX, textureY, width, height);
    }

    public boolean renderHealthbar(class_332 guiGraphics, float partialTicks, class_1041 window, OverlayRenderCallback.Types type) {
        boolean highlight;
        if (!((Boolean)Config.EXTRA_HEART_RENDERER.get()).booleanValue() || type != OverlayRenderCallback.Types.PLAYER_HEALTH) {
            return false;
        }
        if (this.mc.field_1690.field_1842 || !this.mc.field_1761.method_2908() || !(this.mc.method_1560() instanceof class_1657)) {
            return false;
        }
        class_1297 renderViewEnity = this.mc.method_1560();
        if (!(renderViewEnity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)renderViewEnity;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderTexture((int)0, (class_2960)class_329.field_44654);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        this.mc.method_16011().method_15396("health");
        int left_height = 39;
        Object object = FabricLoader.getInstance().getObjectShare().get("raised:hud");
        if (object instanceof Integer) {
            Integer distance = (Integer)object;
            left_height += distance.intValue();
        }
        int width = this.mc.method_22683().method_4486();
        int height = this.mc.method_22683().method_4502();
        int updateCounter = this.mc.field_1705.method_1738();
        int health = class_3532.method_15386((float)player.method_6032());
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.field_6008 > 0) {
            this.lastSystemTime = class_156.method_658();
            this.healthUpdateCounter = updateCounter + 20;
        } else if (health > this.playerHealth && player.field_6008 > 0) {
            this.lastSystemTime = class_156.method_658();
            this.healthUpdateCounter = updateCounter + 10;
        }
        if (class_156.method_658() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = class_156.method_658();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        class_1324 attrMaxHealth = player.method_5996(class_5134.field_23716);
        float healthMax = attrMaxHealth == null ? 0.0f : (float)attrMaxHealth.method_6194();
        float absorb = class_3532.method_15386((float)player.method_6067());
        healthMax = Math.min(healthMax, 20.0f);
        health = Math.min(health, 20);
        absorb = Math.min(absorb, 20.0f);
        int healthRows = class_3532.method_15386((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed((long)updateCounter * 312871L);
        int left = width / 2 - 91;
        int top = height - left_height;
        this.regen = -1;
        if (player.method_6059(class_1294.field_5924)) {
            this.regen = updateCounter % 25;
        }
        assert (this.mc.field_1687 != null);
        int TOP = 9 * (this.mc.field_1687.method_28104().method_152() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.method_6059(class_1294.field_5899)) {
            MARGIN += 36;
        } else if (player.method_6059(class_1294.field_5920)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = class_3532.method_15386((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = class_3532.method_15386((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == this.regen) {
                y -= 2;
            }
            this.blit(guiGraphics, class_329.field_44654, x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.blit(guiGraphics, class_329.field_44654, x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.blit(guiGraphics, class_329.field_44654, x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.blit(guiGraphics, class_329.field_44654, x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.blit(guiGraphics, class_329.field_44654, x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.blit(guiGraphics, class_329.field_44654, x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.blit(guiGraphics, class_329.field_44654, x, y, MARGIN + 45, TOP, 9, 9);
        }
        this.renderExtraHearts(guiGraphics, left, top, player);
        this.renderExtraAbsorption(guiGraphics, left, top - rowHeight, player);
        left_height += 10;
        if (absorb > 0.0f) {
            left_height += 10;
        }
        RenderSystem.disableBlend();
        this.mc.method_16011().method_15407();
        return true;
    }

    private int getPotionOffset(class_1657 player) {
        int potionOffset = 0;
        class_1293 potion = player.method_6112(class_1294.field_5920);
        if (potion != null) {
            potionOffset = 18;
        }
        if ((potion = player.method_6112(class_1294.field_5899)) != null) {
            potionOffset = 9;
        }
        assert (this.mc.field_1687 != null);
        if (this.mc.field_1687.method_28104().method_152()) {
            potionOffset += 27;
        }
        return potionOffset;
    }

    private void renderExtraHearts(class_332 guiGraphics, int xBasePos, int yBasePos, class_1657 player) {
        int potionOffset = this.getPotionOffset(player);
        int hp = class_3532.method_15386((float)player.method_6032());
        this.renderCustomHearts(guiGraphics, ICON_HEARTS, xBasePos, yBasePos, potionOffset, hp, false);
    }

    private void renderExtraAbsorption(class_332 guiGraphics, int xBasePos, int yBasePos, class_1657 player) {
        int potionOffset = this.getPotionOffset(player);
        int absorb = class_3532.method_15386((float)player.method_6067());
        this.renderCustomHearts(guiGraphics, ICON_ABSORB, xBasePos, yBasePos, potionOffset, absorb, true);
    }

    private int getYRegenOffset(int i, int offset) {
        return i + offset == this.regen ? -2 : 0;
    }

    private void renderCustomHearts(class_332 guiGraphics, class_2960 texture, int xBasePos, int yBasePos, int potionOffset, int count, boolean absorb) {
        int regenOffset = absorb ? 10 : 0;
        for (int iter = 0; iter < count / 20; ++iter) {
            int renderHearts = (count - 20 * (iter + 1)) / 2;
            int heartIndex = iter % 11;
            if (renderHearts > 10) {
                renderHearts = 10;
            }
            for (int i = 0; i < renderHearts; ++i) {
                int y = this.getYRegenOffset(i, regenOffset);
                if (absorb) {
                    this.blit(guiGraphics, texture, xBasePos + 8 * i, yBasePos + y, 0, 54, 9, 9);
                }
                this.blit(guiGraphics, texture, xBasePos + 8 * i, yBasePos + y, 18 * heartIndex, potionOffset, 9, 9);
            }
            if (count % 2 != 1 || renderHearts >= 10) continue;
            int y = this.getYRegenOffset(renderHearts, regenOffset);
            if (absorb) {
                this.blit(guiGraphics, texture, xBasePos + 8 * renderHearts, yBasePos + y, 0, 54, 9, 9);
            }
            this.blit(guiGraphics, texture, xBasePos + 8 * renderHearts, yBasePos + y, 9 + 18 * heartIndex, potionOffset, 9, 9);
        }
    }
}

